	class WebSocketRequest {
		constructor(params) {
			this.params = params;
			this.key = "6A5AA1D4EAFF4E9FB37E23D68491D6F4";
			this.socketAddress = 'wss://speech.platform.bing.com/consumer/speech/synthesize' +
			'/readaloud/edge/v1?TrustedClientToken=' + this.key;
			this.complete = false;
			this.socket = null;
			this.arrayBuffer = new Array();
			var textEncoder = new TextEncoder();
			this.binaryHeadEnd = textEncoder.encode('Path:audio\r\n').toString();
			this.lastView = null;
			this.format = {
				"context": {
					"synthesis": {
						"audio": {
							"metadataoptions": {
								"sentenceBoundaryEnabled": "false",
								"wordBoundaryEnabled": "false"
							},
							"outputFormat": params.format
						}
					}
				}
			};
			this.audio = null;
		}
		
		isComplete() {
			//console.log("is completed called", this.complete);
			return this.complete;
		}
		
		openSocket() {
			var _this = this;
			this.socket = new WebSocket(this.socketAddress);
			
			this.socket.addEventListener('message', async ({
				data
			}) => {
				if (data instanceof Blob) {						
					const view = new Uint8Array(await data.arrayBuffer());
					_this.arrayBuffer.push(...view.toString().split(_this.binaryHeadEnd)[1].split(',').slice(1).map(i => +i));
					this.lastView = view;
					if (
					(view[0] == 0x00 && view[1] == 0x67 && view[2] == 0x58)) {
						_this.socket.close(1000);
						_this.buildAudio();
						_this.complete = true;
						if (_this.params.callback != null) {
							_this.params.callback();	
						}	
					}
				}
			});

			this.socket.addEventListener('open', function(event) {
				_this.handleSocketOpen(event);

			});
		}
		
		handleSocketOpen(event) {
			this.socket.send('X-Timestamp:' + new Date().toString() +
				'\r\nContent-Type:application/json; ' +
				'charset=utf-8\r\nPath:speech.config\r\n\r\n' + JSON.stringify(this.format));
			var text = this.escapeXml(this.params.text);
			//console.log(text);
			var voicename = this.params.voicename;
			var pitch = this.params.pitch;
			var speed = this.params.speed;
			var ssml = "<speak version='1.0' xmlns='http://www.w3.org/2001/10/synthesis' xmlns:mstts='https://www.w3.org/2001/mstts' xml:lang='en-US'><voice name='" + voicename + "'><prosody pitch='" + pitch + "Hz' rate ='" + speed + "%' volume='+0%'>" + text + "</prosody></voice></speak>";
			var message = 'X-RequestId:' + UUID.createUUID() +
				'\r\nContent-Type:application\/ssml+xml\r\nX-Timestamp:' +
				new Date().toString() + 'Z\r\nPath:ssml\r\n\r\n' + ssml;
			this.socket.send(message);
		}
		
		escapeXml(inputString) {
			var doc = document.implementation.createDocument("", "", null)
			var el = doc.createElement("temp");
			el.textContent = inputString;
			el = el.firstChild;
			var ser =  new XMLSerializer();
			return ser.serializeToString(el);
		}
		
		getAudio() {
			return this.audio;
		}
		
		buildAudio() {
			const blob = new Blob([new Uint8Array(this.arrayBuffer)], {
				type: 'audio/mp3'
			});
			
			this.audio = new Audio();
			this.audio.src = URL.createObjectURL(blob);
		}
	}