	class SpeakManager {
		constructor(options) {
			this.options = options;
			this.requestBuffer = new Array();
			this.audio = null;
			this.playCallback = null;
			this.onSpeakEndCallback = null;
		}
		
		setOnSpeakEndCallback(onSpeakEndCallback) {
			this.onSpeakEndCallback = onSpeakEndCallback;
		}
		
		setPlayCallback(playCallback) {
			this.playCallback = playCallback;
		}
		
		speak(text, voiceName) {
			var _this = this;
			var request = null;
			
			if (this.requestBuffer.length == 0) {
				request = this.createNewRequest(text, voiceName, function () {
					_this.receiveCallback();
				});
			} else {
				request = this.createNewRequest(text, voiceName, null);
			}
			
			this.requestBuffer.push(request);
			request.openSocket();			
		}
		
		stop() {
			try {
				this.audio.src = "";
			} catch (exception) {
				console.log(exception);
			}
		}
		
		receiveCallback(wasTimeout) {		
			if (this.requestBuffer.length > 0) {
				var _this = this;
				// don't shift, just get the first buffer item
				var request = this.requestBuffer[0];
				if (request.isComplete()) {
					this.audio = request.getAudio();
					this.audio.addEventListener('ended', function () {
						if (_this.onSpeakEndCallback != null ) {
							_this.onSpeakEndCallback();
						}
						// shift the first item
						_this.requestBuffer.shift();
						_this.receiveCallback();						
					});					
					if (this.playCallback != null) {
						this.playCallback();
					}
					this.audio.play();
				} else {
					if (wasTimeout === true) {
						_this.requestBuffer.shift();
						_this.receiveCallback();							
					} else {
						// wait for 1 second
						setTimeout(function () {
							_this.receiveCallback(true);
						}, 1000);	
					}
				}
			} else {
				// no more buffer to speak
				if (this.options.callback != null) {
					this.options.callback();
				}					
			}				
		}
		
		createNewRequest(text, voiceName, callback){
			var params = {
				callback: callback,
				text: text,
				voicename: voiceName,
				speed: 0,
				pitch: 0,
				format: "audio-24khz-48kbitrate-mono-mp3"
			};
			return new WebSocketRequest(params);
		}
		
		clear() {
			this.requestBuffer = new Array();
		}
	}